import java.io.*;
import java.util.*;

public class LaunchExeDemo {
    public static void main(String[] args) throws Exception {
        List<String> cmd = new ArrayList<>();
        cmd.add("C:\\tools\\echo_sum.exe");
        cmd.add("7");
        cmd.add("11");

        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);

        Process process = pb.start();

        try (BufferedReader reader = new BufferedReader(
                new InputStreamReader(process.getInputStream()))) {
            String line;
            while ((line = reader.readLine()) != null) {
                System.out.println("EXE says: " + line); // → "Sum: 18"
            }
        }

        int exitCode = process.waitFor();
        System.out.println("Exit code: " + exitCode);
    }
}
